# Multiple testing: introduction
library(SNPassoc)
data(SNPs)
myData<-setupSNP(data=SNPs,colSNPs=6:40,sep="")
myData.o<-setupSNP(SNPs, colSNPs=6:40, sort=TRUE,info=SNPs.info.pos, sep="")
ans<-WGassociation(protein~1,data=myData.o)
ans
Bonferroni.sig(ans, model="log-add", alpha=0.05,include.all.SNPs=FALSE)
0.05/21

# Multiple testing: false discovery rate
data(HapMap)
myDat.HapMap<-setupSNP(HapMap, colSNPs=3:9307, sort = TRUE,info=HapMap.SNPs.pos, sep="")
resHapMap<-WGassociation(group, data=myDat.HapMap, model="log-add")
summary(resHapMap)
pval<-additive(resHapMap)
pval<-pval[!is.na(pval)]
install.packages('qvalue')
library(qvalue)
qobj<-qvalue(pval)
qobj$qvalues[1:4]
max(qobj$qvalues[qobj$pvalues <= 0.001])

# Multiple testing: multtest package
source("http://www.bioconductor.org/biocLite.R")
biocLite("Biobase")
install.packages('multtest')
library(multtest)
procs<-c("Bonferroni","Holm","Hochberg","SidakSS","SidakSD","BH","BY")
res2<-mt.rawp2adjp(pval,procs)
res2$adjp[1:10,]
mt.reject(res2$adjp,seq(0,0.1,0.001))$r

# Multiple testing: permutation tests
resHapMap.perm<-scanWGassociation(group, data=myDat.HapMap,model="log-add", nperm=1000)
summary(resHapMap.perm)
res.perm<- permTest(resHapMap.perm)
print(res.perm)
perms <- attr(resHapMap.perm, "pvalPerm")
dim(perms)
plot(res.perm)
res.perm.rtp<- permTest(resHapMap.perm,method="rtp",K=20)
print(res.perm.rtp)

# Interaction analysis: GxE
ans<-association(log(protein)~snp10001*sex+blood.pre,data=myData,model="codominant")
print(ans,dig=2)

# Interaction analysis: GxG
ans<-association(log(protein)~snp10001*factor(recessive(snp100019))+blood.pre,data=myData, model="codominant")
print(ans,dig=2)
ansCod<-interactionPval(log(protein)~sex, data=myData.o,model="codominant")
ansCod[1:7,1:7]
plot(ansCod)